﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="System.Globalization" %>
<%@ Import Namespace="System.Linq" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title></title>
        <script runat="server">

    public class DuplikatContext : ContextBase {
    
           public DuplikatContext(Context cx) : base(cx) {
           }
    
           bool duplikat = true;
    
           [Caption("Duplikat")]
           public bool Duplikat {
               get { return duplikat; }
               set { duplikat = value; }
           }
    
       }
    
    void OnContextLoading(Object sender, EventArgs args) {
        DokumentHandlowy d = (DokumentHandlowy)dc[typeof(DokumentHandlowy)];
        if (d==null) return;
    
        if (d.Stan!=StanDokumentuHandlowego.Bufor) {
            if (!dc.Context.Contains(typeof(ParametryWydrukuDokumentu.Zatwierdzany)))
                dc.AddRequiredType(typeof(DuplikatContext));
        }
    }
    
    bool duplikat = false;
    DokumentHandlowy dokument;
    bool jestVatZaliczk, końcowy;
    private bool SprawdźPłatności( DokumentHandlowy dokument ) {
        bool result = false;
        foreach( Platnosc platnosc in dokument.Platnosci ) {
            if( platnosc.Kwota.Symbol.Equals( "PLN" ) ) {
                result = true;
            }
        }
        return result;
    }

   private bool SprawdźSwift( DokumentHandlowy dokument ) {
        bool warunek1 = dokument.DaneKontrahenta == null || dokument.RachunekBankowy == null || dokument.RachunekBankowy.Rachunek == null || dokument.RachunekBankowy.Rachunek.SWIFT == "";
        bool warunek2 = false;
        if( dokument.Kontrahent != null && dokument.Kontrahent.RodzajPodmiotu == RodzajPodmiotu.Krajowy ) 
            warunek2 = dokument.RachunekBankowy != null && dokument.RachunekBankowy.Waluta.Symbol.Equals( "PLN" ) && SprawdźPłatności( dokument );   

        return ( warunek1 || warunek2 );
    }

    private bool SprawdźSwift2( DokumentHandlowy dokument ) {
        bool warunek1 = dokument.DaneKontrahenta == null || dokument.RachunekBankowy2 == null || dokument.RachunekBankowy2.Rachunek == null || dokument.RachunekBankowy2.Rachunek.SWIFT == "";
        bool warunek2 = false;
        if( !warunek1 && dokument.Kontrahent != null && dokument.Kontrahent.RodzajPodmiotu == RodzajPodmiotu.Krajowy ) 
            warunek2 = dokument.RachunekBankowy2 != null && dokument.RachunekBankowy2.Waluta.Symbol.Equals( "PLN" ) && SprawdźPłatności( dokument );   

        return ( warunek1 && warunek2 );
    }     		     
    
    private static bool NIPOdbiorcyPusty(DokumentHandlowy dokument)
    {
        if (dokument.Odbiorca == null) return false;
        return string.IsNullOrWhiteSpace(dokument.Odbiorca.NIP) && string.IsNullOrWhiteSpace(dokument.DaneOdbiorcy.EuVAT);
    }

    void OnContextLoad(Object sender, EventArgs args) {
        //
        // Inicjacja pól
        //
        if (dc.Context.Contains(typeof(DuplikatContext)))
            duplikat = ((DuplikatContext)dc[typeof(DuplikatContext)]).Duplikat;

        dokument = (DokumentHandlowy)dc[typeof(DokumentHandlowy)];

        bool nipVisible = dokument.DaneKontrahenta.StatusPodmiotu != StatusPodmiotu.Finalny || !String.IsNullOrEmpty( dokument.DaneKontrahenta.EuVAT );
        NipSection.Visible = nipVisible; 
        NoNipSection.Visible = !nipVisible; 

        if (NIPOdbiorcyPusty(dokument))
            OdbiorcaNIP.Visible = false;
      
        IPieczątkaFirmy pieczątka = ReportHeader.GetPieczątka( dc, null, false);
        var nazwas = pieczątka.NazwaFormatowana;
        var adres1s = pieczątka.Adres.Linia1;
        var adres2s = pieczątka.Adres.Linia2;
        var nips = dokument.Kontrahent.RodzajPodmiotu == RodzajPodmiotu.Krajowy ? pieczątka.NIP : pieczątka.EuVAT.Replace("-", String.Empty);
        var BDO = pieczątka.BDO;
        BDOFirmyS.EditValue = "BDO: " + BDO;

       if(String.IsNullOrWhiteSpace(BDO)){
            BDOFirmyS.Visible = false;
            }

        if(dokument.Wydruk.JestJednostkaNadrzedna) {

            var jednostkaNadrzedna = CRMModule.GetInstance(dokument).PodmiotyPow.JednostkaNadrzedna(null);

            NazwaFirmyS.EditValue = jednostkaNadrzedna.Nazwa;
            AdresFirmySLinia1.EditValue = jednostkaNadrzedna.Adres.Linia1;
            AdresFirmySLinia2.EditValue = jednostkaNadrzedna.Adres.Linia2;
            var nipw = dokument.Kontrahent.RodzajPodmiotu == RodzajPodmiotu.Krajowy ? jednostkaNadrzedna.NIP : jednostkaNadrzedna.EuVAT.Replace("-", String.Empty);
            NipFirmyS.EditValue = nipw;

            NazwaFirmyW.EditValue = nazwas;
            AdresFirmyWLinia1.EditValue = adres1s;
            AdresFirmyWLinia2.EditValue = adres2s;
        } 
        else {
            FirmaWystawca.Visible = false;

            NazwaFirmyS.EditValue = nazwas;
            AdresFirmySLinia1.EditValue = adres1s;
            AdresFirmySLinia2.EditValue = adres2s;
            NipFirmyS.EditValue = nips;
        }

        
        dc.NextPagesHeader = dokument.Numer + "~Strona {0}";

        dc.AdditionalFooterInfo = dokument.Definicja.InformacjeKRS;
        
        colSWW.Visible = dokument.JestSWW;

        if (dokument.RachunekBankowy==null
            || dokument.RachunekBankowy.Rachunek == null
            || dokument.RachunekBankowy.Rachunek.Bank==null)
            labelBank.Visible = false;

        if( !dokument.Definicja.DrukujSWIFTZawsze ) {
            if( SprawdźSwift( dokument ) )
                labelSwift.Visible = false;
        }

        if (dokument.RachunekBankowy2 == null
            || dokument.RachunekBankowy2.Rachunek == null
            || dokument.RachunekBankowy2.Rachunek.Bank == null)
            labelBank2.Visible = false;

        if( SprawdźSwift2( dokument ) )
            labelSwift2.Visible = false;
    
        if( dokument.JestDokZaliczkowy() ) {
            sectionDoZaplaty.Visible = false;
        }

        if (dokument.OdBrutto)
            colWartosc.Caption = "Wartość brutto";
        else
            colWartosc.Caption = "Wartość netto";

        // Ukrywamy kolumne kwoty VAT, jesli dokument nie jest zaliczkowy.
        bool jestMniejszaKwota = dokument.LiczonaOd == SposobLiczeniaVAT.OdNetto ?
            dokument.SumaPozycji.Netto != dokument.Suma.Netto :
            dokument.SumaPozycji.Brutto != dokument.Suma.Brutto;
        jestVatZaliczk =
            (dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) &&
            (dokument.Wydruk.JestSumaPozycji /*&& jestMniejszaKwota*/); // <-- TID: 13891;
        bool nowyObieg;
        końcowy = dokument.JestKoncowy(out nowyObieg);
        SectionVATZamowienia.Visible = końcowy;        
        SectionVATZaliczkowego.Visible = jestVatZaliczk && !dokument.Korekta;
        SectionKorektaZaliczki.Visible = jestVatZaliczk && dokument.Korekta;       
        
        Grid1_VAT.Visible = false; 

        SectionWartBZamowienia.Visible = !SectionVATZaliczkowego.Visible && !końcowy && jestMniejszaKwota;
                 
        colRodzajKorekty.Visible = dokument.DokumentKorygowany != null;
        colPlatnik.Visible = dokument.InnyPłatnik;
        labelOperator.EditValue = dokument.Wydruk.UprawnionyDoWystawienia.FullName;
        labelCopyright.EditValue = dc.Copyright;
        SectionVAT.Visible = dokument.Definicja.SumyVAT != SposobLiczeniaSumVAT.NieLiczyć;

        // TID: 13891;
        if (jestVatZaliczk && !jestMniejszaKwota)
            SectionVAT.Visible = false;

        if (dokument.Wydruk.NabywcaPodatnik == 1)
            SectionVAT.Visible = false;

        if (dokument.ID < 0 || dokument.State == RowState.Modified)
            DataLabelOstrzezenie.EditValue = "Zmiany na dokumencie nie zostały zatwierdzone";
        
        // Ukrywanie kolumn z ceną przed rabatem i rabatem procentowym
        Grid1_CenaPrzedRabatem.Visible = Grid1_RabatP.Visible = dokument.Definicja.DrukowanieCenyIRabatu;

        // Ukrywanie ceny netto/brutto zależnie od typu dokumentu
        Grid1_CenaNettoPoRabacie.Visible = !dokument.OdBrutto;
        Grid1_CenaBruttoPoRabacie.Visible = dokument.OdBrutto;

        if( dokument.Wydruk.JestPłatnośćWielePrzelewów )
                SposobZaplaty.Width = 38;

        if (dokument.Wydruk.JestUproszczony) // ukrywam kolumny, nie patrząc na ich wcześniejszy stan ... 
        {
            Grid_SumyVat_NettoCy.Visible = false;
            Grid_VATZamowienia_NettoCy.Visible = false;
            Grid_VATZaliczkowego_NettoCy.Visible = false;

            Pozycje_Ilosc.Visible = false;
            Pozycje_IloscSym.Visible = false;
            Grid1_CenaNettoPoRabacie.Visible = false;
            Grid1_CenaBruttoPoRabacie.Visible = false;
            colWartosc.Visible = false;
            Grid1_VAT.Visible = false;
            colVat.Visible = false;
            colSWW.Visible = false;
            
        }


        if (String.IsNullOrWhiteSpace(dokument.Wydruk.Procedura))
            dlProcedura.Visible = false;

        lDataEtykieta.Visible = lData.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleData;
        lDataDostawyEtykieta.Visible = lDataDostawy.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleDataDostawy;
        lDataOperacjiEtykieta.Visible = lDataOperacji.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleDataOperacji;
        lDataOtrzymaniaEtykieta.Visible = lDataOtrzymania.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleDataOtrzymania;

        ObcyKorygowany.Visible = dokument.DokumentyKorygowanePierwsze.Any(x => !string.IsNullOrEmpty(x.Obcy.Numer));
    }

    
            void gridNiezaplacone_BeforeRow(object sender, RowEventArgs args) {
                WydrukDokumentu.NiezapłaconeInfo pl = (WydrukDokumentu.NiezapłaconeInfo)
                    args.Row;

                // Mateusz - task 10271
                if( pl.Płatność.SposobZaplaty.Typ != TypySposobowZaplaty.Przelew 
                    || ( pl.Płatność.SposobZaplaty.Typ == TypySposobowZaplaty.Przelew && pl.Płatność.EwidencjaSP.Rachunek.Numer == (pl.Płatność.Dokument as DokumentHandlowy).RachunekBankowy.Rachunek.Numer 
                    && (pl.Płatność.Dokument as DokumentHandlowy).Wydruk.Niezapłacone.Count == 1 ) ) { // dla całej reszty zostawiamy jak leci
                    SposobZaplaty.EditValue = pl.Płatność.SposobZaplaty;
                }
                else  { // a dla przelewu doklejamy numer rachunku
                    SposobZaplaty.AddLine( pl.Płatność.SposobZaplaty + " na rachunek bankowy" );
                    SposobZaplaty.AddLine( pl.Płatność.EwidencjaSP.Rachunek.Numer );
                }

                colPlatnik.EditValue = pl.Płatność.Podmiot.Nazwa + '\n' +
                                       pl.Płatność.Podmiot.Adres + "\nNIP: " +
                                       pl.Płatność.Podmiot.EuVAT;
            }
            void gridZaliczki_BeforeRow(object sender, RowEventArgs args)
            {
                DokumentHandlowy z = (DokumentHandlowy)args.Row;
                DokumentHandlowy d = (DokumentHandlowy)this.dc.Context[typeof(DokumentHandlowy)];
                SubTable st = d.ZaliczkiRelacje;
                if (st.IsEmpty
                    && z.SposobPrzenoszeniaZaliczki == SposobPrzenoszeniaZaliczki.NieDotyczy)
                {
                    this.colZaliczka.EditValue = z.BruttoCy;
                }
                else
                {
                    Currency v = new Currency(decimal.Zero, z.BruttoCy.Symbol);
                    foreach (RelacjaHandlowa.Zaliczka rz in st)
                    {
                        if (rz.Nadrzedny == z)
                        {
                            v += rz.Wartosc;
                        }
                    }
                    this.colZaliczka.EditValue = v;
                }
            }	
</script>
        <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
        <meta content="C#" name="CODE_LANGUAGE" />
        <meta content="JavaScript" name="vs_defaultClientScript" />
        <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
    </head>
    <body>
    <font face="Courier New" size="smaller">
        <form id="Sprzedaż" method="post" runat="server">
            <ea:datacontext id="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" oncontextloading="OnContextLoading"
                oncontextload="OnContextLoad"></ea:datacontext><ea:datalabel id="DataLabel1" runat="server" DataMember="Definicja.TytulWydruku">
                </ea:datalabel><ea:datalabel id="DataLabel2" runat="server" DataMember="Wydruk.MalyPodatnik_Do_20130101">
                <ValuesMap>
                    <ea:ValuesPair Key="False" Value="" />
                    <ea:ValuesPair Key="True" Value=" MP " />
                </ValuesMap>
            </ea:datalabel>&nbsp;<b><ea:datalabel id="DataLabel3" runat="server" DataMember="Numer"></ea:datalabel>
                <% if (duplikat) { %>
                DUPLIKAT
                <% } %>
            </b>

            <ea:DataLabel ID="dlProcedura" runat="server" DataMember="Wydruk.Procedura" Format="<br /><span style='font-size: 13px;'>{0}</span>">
            </ea:DataLabel>

            <ea:DataLabel ID="DataLabel8" runat="server" DataMember="Wydruk.MalyPodatnik_Od_20130101" >
                <ValuesMap>
                    <ea:ValuesPair Key="False" Value=""></ea:ValuesPair>
                    <ea:ValuesPair Key="True" Value="<br /><span style='font-size: 13px;'>metoda kasowa</span>"></ea:ValuesPair>
                </ValuesMap>
            </ea:DataLabel>

            <ea:DataLabel runat="server" DataMember="Stan" id="DataLabel4">
                <ValuesMap>
                    <ea:ValuesPair Key="Anulowany" Value="&lt;br&gt;Dokument został anulowany"></ea:ValuesPair>
                    <ea:ValuesPair Key="Bufor" Value="&lt;br&gt;Dokument nie został zatwierdzony"></ea:ValuesPair>
                    <ea:ValuesPair Key="Zablokowany" Value=""></ea:ValuesPair>
                    <ea:ValuesPair Key="Zatwierdzony" Value=""></ea:ValuesPair>
                </ValuesMap>
            </ea:DataLabel>
            <br>
            <ea:DataLabel ID="DataLabelOstrzezenie" runat="server"></ea:DataLabel>
            <br/>
            
            <% if (dokument.Wydruk.DatyDokumentu.IsVisibleData) { %>
            &nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataEtykieta" NonBreakSpace="True" id="lDataEtykieta" WidthChars="35" Align="Left"></ea:datalabel></i>
            <ea:datalabel id="lData" runat="server" DataMember="Wydruk.DatyDokumentu.Data"></ea:datalabel><br>
            <% } %> 

            <% if (dokument.Wydruk.DatyDokumentu.IsVisibleDataDostawy) { %>
            &nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataDostawyEtykieta" NonBreakSpace="True" id="lDataDostawyEtykieta" WidthChars="35" Align="Left"></ea:datalabel></i>
            <ea:datalabel id="lDataDostawy" runat="server" DataMember="Wydruk.DatyDokumentu.DataDostawy"></ea:datalabel><br>
            <% } %> 
            
            <% if (dokument.Wydruk.DatyDokumentu.IsVisibleDataOperacji) { %>
            &nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacjiEtykieta" NonBreakSpace="True" id="lDataOperacjiEtykieta" WidthChars="35" Align="Left"></ea:datalabel></i>
            <ea:datalabel id="lDataOperacji" runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacji"></ea:datalabel><br>
            <% } %> 

            <% if (dokument.Wydruk.DatyDokumentu.IsVisibleDataOtrzymania) { %>
            &nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOtrzymaniaEtykieta" NonBreakSpace="True" id="lDataOtrzymaniaEtykieta" WidthChars="35" Align="Left"></ea:datalabel></i>
            <ea:datalabel id="lDataOtrzymania" runat="server" DataMember="Wydruk.DatyDokumentu.DataOtrzymania"></ea:datalabel><br>
            <% } %> 

            <% if (duplikat) { %>
            &nbsp;&nbsp;&nbsp;&nbsp;<i>Data wystawienia duplikatu:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</i>
            <%= Date.Today%>
            <br>
            <% } %>

            <ea:Section ID="Section1" Runat="server" DataMember="DokumentKorygowany" ConditionValue="IS NOT NULL" Width="100%">
            <i>Dokument korygowany:----------------------------------------------------------</i><br>
            <ea:datarepeater runat="server" rowtypename="Soneta.Handel.DokumentHandlowy,Soneta.Handel" DataMember="DokumentyKorygowanePierwsze">
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel runat="server" DataMember="Numer"></ea:datalabel>

                <ea:Section  ID="ObcyKorygowany" runat="server" EncodeHTML="True">
                                            <br />
                                            <span style="font-weight: normal; font-size: 13px;" >
                                                Dokument obcy nr:                                          
                                            <ea:DataLabel runat="server" DataMember="Obcy.Numer" EncodeHTML="True">
                                            </ea:DataLabel>
                                            </span>
                                        </ea:Section>


                <br/>
                &nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataEtykieta" NonBreakSpace="True" WidthChars="35" Align="Left"></ea:datalabel></i>
            <ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.Data"></ea:datalabel>
                <br/>
                &nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacjiEtykieta" NonBreakSpace="True" WidthChars="35" Align="Left"></ea:datalabel></i>
            <ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacji"></ea:datalabel>
                <br />
            </ea:datarepeater>
            </ea:Section>

            <ea:Section ID="FirmaSprzedawca" runat="server"> 
            <i>Sprzedawca:-------------------------------------------------------------------</i><br>
            <ea:datalabel id="NazwaFirmyS" runat="server" LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
            <ea:datalabel id="AdresFirmySLinia1" runat="server" LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
            <ea:datalabel id="AdresFirmySLinia2" runat="server" LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
            &nbsp;&nbsp;&nbsp;&nbsp;NIP:
            <ea:datalabel id="NipFirmyS" runat="server"></ea:datalabel>
                <br/>
             &nbsp;&nbsp;&nbsp;
            <ea:DataLabel ID="BDOFirmyS" runat="server" Bold="False" EncodeHTML="True" />
                <br />
            </ea:Section>
                        
            <ea:Section ID="FirmaWystawca" runat="server"> 
            <i>Wystawca:-------------------------------------------------------------------</i><br>
            <ea:datalabel id="NazwaFirmyW" runat="server" LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
            <ea:datalabel id="AdresFirmyWLinia1" runat="server" LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
            <ea:datalabel id="AdresFirmyWLinia2" runat="server" LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
            </ea:Section>

            <!-- Oddział firmy -->
            <ea:Section ID="OddzialFirmy" runat="server" DataMember="Wydruk.JestOddzial">
                <em style="text-decoration: none;">Oddział:</em><br />
                <ea:DataLabel ID="DataLabel42" runat="server" EncodeHTML="True" DataMember="Wydruk.Oddział.Nazwa" LeftMargin="4" ></ea:DataLabel><br />
                <ea:DataLabel ID="DataLabel44" runat="server" EncodeHTML="True" Bold="false" DataMember="Wydruk.Oddział.Adres.Linia1" LeftMargin="4" ></ea:DataLabel><br />
                <ea:DataLabel ID="DataLabel45" runat="server" EncodeHTML="True" Bold="false" DataMember="Wydruk.Oddział.Adres.Linia2" LeftMargin="4" ></ea:DataLabel><br />
            </ea:Section>
            <!-- Oddział firmy -->                        
            <ea:Section ID="sectionBank" runat="server" DataMember="IsRachunekBankowy">
                <i>Konto bankowe:</i><br>
            </ea:Section>
            <ea:DataLabel id="labelBank" runat="server" DataMember="RachunekBankowy.Rachunek.Bank.Nazwa" Bold="False"
                Format="{0}<br>" LeftMargin="4"></ea:DataLabel><ea:DataLabel id="labelSwift" runat="server" DataMember="RachunekBankowy.Rachunek.SWIFT" Bold="False"
                Format="SWIFT: {0}<br>" LeftMargin="4"></ea:DataLabel><ea:datalabel id="DataLabel13" runat="server" DataMember="RachunekBankowy.Rachunek.Numer" LeftMargin="4"></ea:datalabel><br>
            <ea:Section id="DrugiRachunekSection" runat="server" DataMember="IsRachunekBankowy2">
            <i>Drugie konto bankowe:</i><br>
            <ea:DataLabel id="labelBank2" runat="server" DataMember="RachunekBankowy2.Rachunek.Bank.Nazwa" Bold="False"
                Format="{0}<br>" LeftMargin="4"></ea:DataLabel><ea:DataLabel id="labelSwift2" runat="server" DataMember="RachunekBankowy2.Rachunek.SWIFT" Bold="False"
                Format="SWIFT: {0}<br>" LeftMargin="4"></ea:DataLabel><ea:datalabel id="DataLabel47" runat="server" DataMember="RachunekBankowy2.Rachunek.Numer" LeftMargin="4"></ea:datalabel><br>
            </ea:Section>

            <i>Nabywca:----------------------------------------------------------------------</i><br>
            <ea:Section ID="NabywcaDaneSection" runat="server" DataMember="Wydruk.NieJestUproszczony">
            <ea:datalabel id="DataLabel14" runat="server" DataMember="DaneKontrahenta.NazwaFormatowana" LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
            <ea:datalabel id="DataLabel15" runat="server" DataMember="DaneKontrahenta.Adres.Linia1" EncodeHTML="True" LeftMargin="4"></ea:datalabel><br>
            <ea:datalabel id="DataLabel16" runat="server" DataMember="DaneKontrahenta.Adres.Linia2" EncodeHTML="True" LeftMargin="4"></ea:datalabel>
            <br/>
            </ea:Section>
            <ea:Section ID="NipSection" runat="server" >
              &nbsp;&nbsp;&nbsp;&nbsp;NIP:
              <ea:datalabel id="DataLabel17" runat="server" DataMember="DaneKontrahenta.EuVAT" Align="Left" WidthChars="61"></ea:datalabel> Strona: 1<br />
            </ea:Section>
            <ea:Section ID="NoNipSection" runat="server">
              <ea:datalabel runat="server" DataMember="DaneKontrahenta.EuVAT" Align="Left" WidthChars="70"></ea:datalabel> Strona: 1<br />
            </ea:Section>

            <ea:Section ID="Section2" Runat="server" DataMember="Wydruk.JestOdbiorca" Width="100%">
            <i>Odbiorca:---------------------------------------------------------------------</i><br>
            <ea:datalabel id="DataLabel18" runat="server" DataMember="DaneOdbiorcy.NazwaFormatowana" EncodeHTML="True" LeftMargin="4"></ea:datalabel><br>
            <ea:datalabel id="DataLabel19" runat="server" DataMember="DaneOdbiorcy.Adres.Linia1" EncodeHTML="True" LeftMargin="4"></ea:datalabel><br>
            <ea:datalabel id="DataLabel20" runat="server" DataMember="DaneOdbiorcy.Adres.Linia2" EncodeHTML="True" LeftMargin="4"></ea:datalabel><br>
            <ea:Section ID="OdbiorcaNIP" runat="server" >
            &nbsp;&nbsp;&nbsp;&nbsp;NIP:
            <ea:datalabel id="DataLabel21" runat="server" DataMember="DaneOdbiorcy.EuVAT"></ea:datalabel><br>
            </ea:Section>
            </ea:Section>
            <small>
                <ea:Section id="KursSection" runat="server" DataMember="Wydruk.JestWaluta" Width="100%">
                    <FONT size="2">Kurs <STRONG>1 </STRONG>
                        <ea:DataLabel id="DataLabel31" runat="server" DataMember="BruttoCy.Symbol"></ea:DataLabel>&nbsp;=
                        <ea:DataLabel id="KursWaluty" runat="server" DataMember="KursWaluty"></ea:DataLabel><STRONG>&nbsp;PLN</STRONG>
                        z dnia
                        <ea:DataLabel id="DataLabel32" runat="server" DataMember="DataOgłoszeniaKursu"></ea:DataLabel>&nbsp; 
                        (
                        <ea:DataLabel id="DataLabel33" runat="server" DataMember="TabelaKursowa"></ea:DataLabel>)</FONT></ea:Section>
                <ea:TextGrid runat="server" id="TextGrid1" DataMember="Wydruk.PozycjeRazem" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
                    GroupData0="Workers.WydrukPozycji.SekcjaDokumentu" GroupLine="{0}">
                    <Columns>
                        <ea:GridColumn Width="3" Align="Right" DataMember="Lp" Caption="Lp." Runat="server"></ea:GridColumn>
                        <ea:GridColumn DataMember="NazwaObieLinie" Caption="Nazwa towaru/usługi" EncodeHTML="True" Runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="Pozycje_Ilosc" Width="7" RightBorder="None" Align="Right" DataMember="Ilosc.Value" Caption="Ilość" Runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="Pozycje_IloscSym" Width="4" DataMember="Ilosc.Symbol" Caption="jm." Runat="server"></ea:GridColumn>
                        <ea:GridColumn runat="server" ID="Grid1_CenaPrzedRabatem" DataMember="Cena" Width="15" Caption="Cena przed rabatem" Align="Right"></ea:GridColumn>
                        <ea:GridColumn runat="server" ID="Grid1_RabatP" DataMember="Rabat" Width="10" Caption="Rabat %" Align="Right"></ea:GridColumn>
                        <ea:GridColumn ID="Grid1_CenaNettoPoRabacie" Width="15" Align="Right" DataMember="CenaNettoPoRabacie" Caption="Cena netto" Runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="Grid1_CenaBruttoPoRabacie" Width="15" Align="Right" DataMember="CenaBruttoPoRabacie" Caption="Cena brutto" Runat="server"></ea:GridColumn>
                        <ea:GridColumn Width="16" Align="Right" DataMember="WartoscCy" Caption="Wartość" Runat="server" ID="colWartosc"></ea:GridColumn>
                        <ea:GridColumn ID="colVat" Width="6" Align="Center" DataMember="DefinicjaStawki" Caption="St.VAT" Runat="server"></ea:GridColumn>
                        <ea:GridColumn Width="18" Align="Right" DataMember="Suma.VAT" Caption="Kwota VAT" ID="Grid1_VAT" runat="server"></ea:GridColumn>
                        <ea:GridColumn Width="15" DataMember="SWW" Caption="PKWiU" Runat="server" ID="colSWW"></ea:GridColumn>
                        <ea:GridColumn Runat="server" ID="colRodzajKorekty" Caption="Zmiana|(Przyczyna kor.)" DataMember="RodzajKorektyOpis"
                            Width="16"></ea:GridColumn>
                    </Columns>
                </ea:TextGrid>
            </small>

            <ea:Section ID="SectionKorektaZaliczki" runat="server" Width="100%" Visible="false">
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                Korekta zaliczki:
            </ea:Section>

            <ea:Section ID="SectionVATZamowienia" runat="server" Width="100%">
                <small>
                    <ea:TextGrid runat="server" id="Grid_VATZamowienia" 
                        RowTypeName="Soneta.Handel.DokumentZaliczkowy.SumaVATAdapter,Soneta.Handel"
                        DataMember="Workers.DokumentZaliczkowy.TabelaVAT" ShowFirstLine="False" LeftMargin="57">
                        <Columns>
                            <ea:GridColumn Width="14" Align="Right" DataMember="DefinicjaStawki" Total="Info" Caption="Stawka VAT" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="Grid_VATZamowienia_NettoCy" Width="18" Align="Right" DataMember="Suma.NettoCy" Total="Sum" Caption="Netto" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="18" Align="Right" DataMember="Suma.VATCy" Total="Sum" Caption="Kwota VAT" Format="{0:n}" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="18" Align="Right" DataMember="Suma.BruttoCy" Total="Sum" Caption="Brutto" runat="server"></ea:GridColumn>
                        </Columns>
                    </ea:TextGrid>
                </small>
                <br/><br />
            </ea:Section>

            <ea:Section ID="SectionVATZaliczkowego" runat="server" Width="100%">
                       <table border="0">
            <tr>
            <td style="width:500px; text-align:right; vertical-align:bottom;">
                <pre><i> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 
                Wartość zamówienia:</i></pre>			              
            </td>
            <td  align="right">
                <small>
                    <ea:TextGrid runat="server" id="Grid_VATZaliczkowego" 
                        RowTypeName="Soneta.Handel.DokumentZaliczkowy.SumaVATAdapter,Soneta.Handel"
                        DataMember="Workers.DokumentZaliczkowy.TabelaVAT" ShowFirstLine="False" LeftMargin="5">
                        <Columns>
                            <ea:GridColumn Width="14" Align="Right" DataMember="DefinicjaStawki" Total="Info" Caption="Stawka VAT" runat="server"></ea:GridColumn>
                            <ea:GridColumn  ID="Grid_VATZaliczkowego_NettoCy" Width="18" Align="Right" DataMember="Suma.NettoCy" Total="Sum" Caption="Netto" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="18" Align="Right" DataMember="Suma.VATCy" Total="Sum" Caption="Kwota VAT" Format="{0:n}" runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="18" Align="Right" DataMember="Suma.BruttoCy" Total="Sum" Caption="Brutto" runat="server"></ea:GridColumn>
                        </Columns>
                    </ea:TextGrid>
                </small>
                </td>
                </tr>
                </table>
                <br /> 

                <ea:KeepLines ID="Keep2" runat="server" NumberLines="4" WidthChars="80"></ea:KeepLines>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i>Kwota zaliczki:</i>&nbsp;
                <b>
                    <ea:datalabel id="DataLabel230" runat="server" DataMember="BruttoCy"></ea:datalabel>
                </b><br/>
                <i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Słownie:</i>
                <small>
                    <ea:datalabel id="DataLabel240" runat="server" DataMember="BruttoCy" Format="{0:+t}"></ea:datalabel>
                </small><br/>
            </ea:Section>

            <br />
                <ea:Section ID="SectionVAT" Runat="server" Pagination="True">
                            <table border="0">
            <tr>
            <td width="100%" style="text-align:right; vertical-align:bottom;">
            <% if (jestVatZaliczk && !końcowy)
               { %>
             <pre><i> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Tabela VAT zaliczki:</i></pre>
             <% } %>
            </td>
            <td  align="right">

            <small>
                <ea:TextGrid runat="server" id="Grid_SumyVat" DataMember="SumyVAT" RowTypeName="Soneta.Handel.SumaVAT,Soneta.Handel"
                    ShowFirstLine="False" LeftMargin="5">
                    <Columns>
                        <ea:GridColumn Width="14" Align="Center" DataMember="DefinicjaStawki" Total="Info" Caption="Stawka VAT" Runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="Grid_SumyVat_NettoCy" Width="18" Align="Right" DataMember="Suma.NettoCy" Total="Sum" Caption="Kwota netto" Runat="server"></ea:GridColumn>
                        <ea:GridColumn Width="18" Align="Right" DataMember="Suma.VATCy" Total="Sum" Caption="Kwota VAT" Runat="server"></ea:GridColumn>
                        <ea:GridColumn Width="18" Align="Right" DataMember="Suma.BruttoCy" Total="Sum" Caption="Kwota brutto" Runat="server"></ea:GridColumn>
                    </Columns>
                </ea:TextGrid>
                <ea:Section ID="Section9" Runat="server" DataMember="DokumentKorygowany" ConditionValue="IS NOT NULL">
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel39" runat="server" DataMember="Wydruk.InfoKorekty1"></ea:datalabel><br>
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel40" runat="server" DataMember="Wydruk.InfoKorekty2"></ea:datalabel>
                </ea:Section>
            </small>
                            </td>
                </tr>
                </table>

                </ea:Section>
            <ea:Section ID="SectionWartBZamowienia" Runat="server" DataMember="Wydruk.JestSumaPozycji" Pagination="True" WidthChars="80">
            <i>Wartość brutto zamówienia:</i>
            <ea:datalabel ID="labelSumaPozycji" Bold="False" DataMember="SumaPozycji.Brutto" runat="server"></ea:datalabel>PLN</ea:Section>
            <ea:Section ID="section4" Runat="server" DataMember="DokumentyZaliczkowe" Pagination="True" WidthChars="80">
            <pre><i>Faktury zaliczkowe:</i></pre>
            <small>
            <ea:TextGrid id="gridZaliczkowe" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" DataMember="Wydruk.DokumentyZaliczkowe" OnBeforeRow="gridZaliczki_BeforeRow">
                <Columns>
                    <ea:GridColumn Runat="server" Caption="Lp." DataMember="#" Align="Right" Width="3"></ea:GridColumn>
                    <ea:GridColumn Runat="server" DataMember="Numer" Width="36"></ea:GridColumn>
                    <ea:GridColumn Runat="server" Total="Info" DataMember="Data" Width="12"></ea:GridColumn>
                    <ea:GridColumn Runat="server" Total="Sum" DataMember="BruttoCy" Align="Right" Width="18"></ea:GridColumn>
                    <ea:GridColumn runat="server" Width="18" Align="Right" Total="Sum" ID="colZaliczka"
                        Caption="Rozliczona zaliczka"></ea:GridColumn>
                </Columns>
            </ea:TextGrid>
            </small>
            </ea:Section>
            <br>
            <ea:KeepLines ID="Keep1" runat="server" NumberLines="4" WidthChars="80">
            </ea:KeepLines>

            <!-- Pozostało do zapłaty -->
            <ea:Section ID="sectionDoZaplaty" runat="server">
            <i>
                <ea:datalabel id="DataLabel22" runat="server" DataMember="Wydruk.KierunekZapłaty" NonBreakSpace="True"
                    Format="{0}:" WidthChars="21" Align="Right">
                </ea:datalabel></i>&nbsp;<b><ea:datalabel id="DataLabel23" runat="server" DataMember="Wydruk.BruttoCyPlus"></ea:datalabel></b><br>
            <i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Słownie:</i>
            <small>
                <ea:datalabel id="DataLabel24" runat="server" DataMember="BruttoCy" Format="{0:+t}"></ea:datalabel></small><br>
            </ea:Section>
            
            <!-- Grid - rozliczone zaliczki -->
            <ea:Section ID="section5" Runat="server" DataMember="Zaliczki" Pagination="True" WidthChars="80">
            <pre><i>Rozliczone zaliczki:</i></pre>
            <small>
            <br>
            <ea:TextGrid ID="gridZaplaty" Runat="server" DataMember="Zaliczki" RowTypeName="Soneta.Handel.RelacjaZaliczki,Soneta.Handel">
                <Columns>
                    <ea:GridColumn Runat="server" Caption="Lp." DataMember="#" Align="Right" Width="3"></ea:GridColumn>
                    <ea:GridColumn Runat="server" Caption="Spos&#243;b zapłaty" DataMember="Zaplata.SposobZaplaty" Align="Center" Width="16"></ea:GridColumn>
                    <ea:GridColumn Runat="server" Caption="Data zapłaty" DataMember="Zaplata.DataDokumentu" Align="Center" Width="12"></ea:GridColumn>
                    <ea:GridColumn Runat="server" Caption="Kwota" DataMember="KwotaRozliczonaDokumentu" Align="Right" Width="16"></ea:GridColumn>
                    <ea:GridColumn Runat="server" Caption="Numer dokumentu" DataMember="Zaplata.NumerDokumentu" Width="26"></ea:GridColumn>
                </Columns>
            </ea:TextGrid>
            </small>
            </ea:Section>
            <ea:Section ID="section6" Runat="server" DataMember="Wydruk.ZapłataCzęściowa" Pagination="True" WidthChars="80">
            <br>
            <ea:datalabel runat="server" DataMember="Wydruk.Zapłacono" id="Datalabel25"></ea:datalabel>
            <ea:datalabel runat="server" DataMember="Zapłata.SposobZaplaty.Biernik" id="Datalabel26"></ea:datalabel>
            : <b>
                <ea:datalabel runat="server" DataMember="Zapłata.SłownieUpr" id="Datalabel27"></ea:datalabel></b><br>
            </ea:Section>
            <ea:Section ID="section7" Runat="server" DataMember="Wydruk.ZapłataCałkowita" Pagination="True" WidthChars="80">
            <br />
            <ea:Section ID="Section3" runat="server">
                <em>                
                    <ea:DataLabel runat="server" DataMember="Wydruk.ZaplaconoInfo"
                        Bold="False">
                    </ea:DataLabel>                    
                    </em>
            </ea:Section>
            </ea:Section>
             <!-- Mateusz - zapłata zaliczkami 100% -->
            <ea:Section runat="server" DataMember="Wydruk.ZaliczkaPokrywaCałość">
                    Pozostało do zapłaty 0 PLN.
            </ea:Section>
            <ea:Section ID="section8" Runat="server" DataMember="Wydruk.SąNiezapłacone" Pagination="True" WidthChars="80">
            <br>
            <i>
                <ea:DataLabel ID="DataLabel43" runat="server" DataMember="Wydruk.KierunekZapłaty" Bold="False" Format="{0}:">
                    <ValuesMap>
                        <ea:ValuesPair Key="Do zapłaty" Value="Pozostało do zapłaty"></ea:ValuesPair>
                        <ea:ValuesPair Key="Do zwrotu" Value="Pozostało do zwrotu"></ea:ValuesPair>
                        <ea:ValuesPair Key="Wartość" Value="Wartość" />
                        <ea:ValuesPair Key="Zapłacona zaliczka" Value="Do zapłaty"></ea:ValuesPair>
                        <ea:ValuesPair Key="Zwr&#243;cona zaliczka" Value="Zwr&#243;cona zaliczka"></ea:ValuesPair>
                    </ValuesMap>
                </ea:DataLabel></i>
            <br />
            <small>
            <ea:TextGrid ID="gridNiezaplacone" Runat="server" DataMember="Wydruk.Niezapłacone" RowTypeName="Soneta.Handel.WydrukDokumentu+NiezapłaconeInfo,Soneta.Handel" OnBeforeRow="gridNiezaplacone_BeforeRow">
                <Columns>
                    <ea:GridColumn Runat="server" Caption="Lp." DataMember="#" Align="Right" Width="3"></ea:GridColumn>
                    <ea:GridColumn Runat="server" Caption="Spos&#243;b zapłaty" ID="SposobZaplaty"
                        Align="Center" Width="16"></ea:GridColumn>
                    <ea:GridColumn Runat="server" Caption="Termin" DataMember="Płatność.Termin" Align="Center"
                        Width="12"></ea:GridColumn>
                    <ea:GridColumn Runat="server" DataMember="Kwota" Align="Right" Width="16"></ea:GridColumn>
                    <ea:GridColumn Runat="server" ID="colPlatnik" Caption="Płatnik"
                        Width="46" EncodeHTML="True"></ea:GridColumn>
                </Columns>
            </ea:TextGrid>
            </small>
            </ea:Section>
            <ea:Section ID="sectionNumeryNadrzednych" runat="server" DataMember="Wydruk.CzyDrukowacNumeryPowiazanych" Pagination="True" WidthChar="80">
                <em>Dokumenty powiązane:</em>
                <div>
                    <ea:DataLabel ID="labelNumeryNadrzednych" runat="server" DataMember="Wydruk.NumeryNadrzędneZK" Bold="False" WidthChar="60"></ea:DataLabel>
                    <ea:DataLabel ID="labelNumeryPodrzednych" runat="server" DataMember="Wydruk.NumeryPodrzędneBK" Bold="False" WidthChar="60"></ea:DataLabel>
                </div>
            </ea:Section>
            <ea:Section ID="section10" Runat="server" Pagination="True" WidthChars="80">
            <p><ea:DataLabel ID="labelOpis" runat="server" DataMember="Opis" Bold="False"></ea:DataLabel></p>
            <p><ea:DataLabel ID="labelOpisWydruku" runat="server" DataMember="Wydruk.OpisWydruku" Bold="False"></ea:DataLabel>&nbsp;</p>
            ---------------------------------------+---------------------------------------<br />
            <ea:DataLabel ID="labelOperator" Runat="server" Align="Center" WidthChars="40" Bold="False">
            </ea:DataLabel>|<ea:DataLabel ID="DataLabel37" Runat="server" DataMember="Osoba"
                Align="Center" WidthChars="39" Bold="False">
            </ea:DataLabel><br />                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|<br />
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|<br />
            &nbsp;&nbsp;&nbsp;&nbsp; ................................&nbsp;&nbsp;&nbsp; |    ...............................<br />
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Podpis osoby upoważnionej&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Podpis osoby upoważnionej<br />
            <ea:DataLabel ID="DataLabel38" Runat="server" DataMember="Wydruk.NazwaDokumentu" Align="Center" WidthChars="40" Format="do wystawienia {0}" Bold="False">
            </ea:DataLabel>|<ea:DataLabel ID="DataLabel34" Runat="server" DataMember="Wydruk.NazwaDokumentu" Align="Center" WidthChars="39" Format="do otrzymania {0}" Bold="False">
            </ea:DataLabel>
            <br />
            <small>
            <!--
            <ea:DataLabel id="labelCopyright" runat="server" Bold="False" Align="Right" WidthChars="130"></ea:DataLabel>
            -->
            </small>
            <cc1:ReportFooter id="ReportFooter1" runat="server" Height="105px" TheEnd="False">
            </cc1:ReportFooter>
            </ea:Section>
            <ea:PageBreak id="PageBreak1" runat="server"></ea:PageBreak>
        </form>
    </font>
    </body>
</HTML>

